/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.discordipc;

import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.Packet;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.User;
import com.jagrosh.discordipc.entities.pipe.Pipe;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import com.jagrosh.discordipc.entities.pipe.listener.PipeCreationListener;
import com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.json.JSONException;
import org.json.JSONObject;

public final class IPCClient
implements Closeable {
    private final long clientId;
    private volatile Pipe pipe;
    private IPCListener listener = null;
    private Thread readThread = null;
    private User user = null;

    public IPCClient(long clientId) {
        this.clientId = clientId;
    }

    private static int getPID() {
        String pr = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(pr.substring(0, pr.indexOf(64)));
    }

    public void setListener(IPCListener listener) {
        this.listener = listener;
        if (this.pipe != null) {
            this.pipe.setListener(listener);
        }
    }

    public void connect(DiscordBuild ... preferredOrder) throws NoDiscordClientException {
        this.checkConnected(false);
        this.pipe = null;
        PipeCreationListener pipeCreationListener = user -> {
            this.user = user;
        };
        this.pipe = Pipe.openPipe(this, pipeCreationListener, this.clientId, preferredOrder);
        if (this.listener != null) {
            this.listener.onReady(this, this.user);
        }
        this.startReading();
    }

    public void sendRichPresence(RichPresence presence) {
        this.checkConnected(true);
        this.pipe.send(Packet.OpCode.FRAME, new JSONObject().put("cmd", "SET_ACTIVITY").put("args", new JSONObject().put("pid", IPCClient.getPID()).put("activity", presence == null ? null : presence.toJson())));
    }

    public void subscribe(Event sub) {
        this.checkConnected(true);
        if (!sub.isSubscribable()) {
            throw new IllegalStateException("Cannot subscribe to " + (Object)((Object)sub) + " event!");
        }
        this.pipe.send(Packet.OpCode.FRAME, new JSONObject().put("cmd", "SUBSCRIBE").put("evt", sub.name()));
    }

    public PipeStatus getStatus() {
        if (this.pipe == null) {
            return PipeStatus.UNINITIALIZED;
        }
        return this.pipe.getStatus();
    }

    @Override
    public void close() {
        this.checkConnected(true);
        try {
            this.pipe.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close pipe: " + e);
        }
    }

    public DiscordBuild getDiscordBuild() {
        if (this.pipe == null) {
            return null;
        }
        return this.pipe.getDiscordBuild();
    }

    private void checkConnected(boolean connected) {
        if (connected && this.getStatus() != PipeStatus.CONNECTED) {
            throw new IllegalStateException(String.format("IPCClient (ID: %d) is not connected!", this.clientId));
        }
        if (!connected && this.getStatus() == PipeStatus.CONNECTED) {
            throw new IllegalStateException(String.format("IPCClient (ID: %d) is already connected!", this.clientId));
        }
    }

    private void startReading() {
        this.readThread = new Thread(this::lambda$startReading$1);
        this.readThread.start();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$startReading$1() {
        try {
            while (true) lbl-1000:
            // 5 sources

            {
                if ((p = this.pipe.read()).getOp() == Packet.OpCode.CLOSE) {
                    this.pipe.setStatus(PipeStatus.DISCONNECTED);
                    if (this.listener == null) return;
                    this.listener.onClose(this, p.getJson());
                    return;
                }
                json = p.getJson();
                if (this.listener == null || !json.has("cmd") || !json.getString("cmd").equals("DISPATCH")) continue;
                try {
                    data = json.getJSONObject("data");
                    switch (1.$SwitchMap$com$jagrosh$discordipc$IPCClient$Event[Event.of(json.getString("evt")).ordinal()]) {
                        case 1: {
                            this.listener.onActivityJoin(this, data.getString("secret"));
                            break;
                        }
                        case 2: {
                            this.listener.onActivitySpectate(this, data.getString("secret"));
                            break;
                        }
                        case 3: {
                            u = data.getJSONObject("user");
                            user = new User(u.getString("username"), u.getString("discriminator"), Long.parseLong(u.getString("id")), u.optString("avatar", null));
                            this.listener.onActivityJoinRequest(this, data.optString("secret", null), user);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
            this.pipe.setStatus(PipeStatus.DISCONNECTED);
            if (this.listener == null) return;
            this.listener.onDisconnect(this, e);
        }
        ** GOTO lbl-1000
    }

    public static enum Event {
        NULL(false),
        READY(false),
        ERROR(false),
        ACTIVITY_JOIN(true),
        ACTIVITY_SPECTATE(true),
        ACTIVITY_JOIN_REQUEST(true),
        UNKNOWN(false);

        private final boolean subscribable;

        private Event(boolean subscribable) {
            this.subscribable = subscribable;
        }

        static Event of(String str) {
            if (str == null) {
                return NULL;
            }
            for (Event s : Event.values()) {
                if (s == UNKNOWN || !s.name().equalsIgnoreCase(str)) continue;
                return s;
            }
            return UNKNOWN;
        }

        public boolean isSubscribable() {
            return this.subscribable;
        }
    }
}

